<?php /* Template Name: Index */ get_header(); ?>

<?php get_header(); ?>


<div id="carousel" class="carousel slide" data-ride="carousel">
   <ol class="carousel-indicators">
      <li data-target="#carousel" data-slide-to="0"></li>
      <li data-target="#carousel" data-slide-to="1"></li>
      <li data-target="#carousel" data-slide-to="2"></li>
      <li data-target="#carousel" data-slide-to="3" class="active"></li>
   </ol>
   <div class="carousel-inner">
      <! ---------SLIDER 01--------->
      <div class="carousel-item">
         <img class="d-block" src="<?php echo get_template_directory_uri(); ?>/img/slider/slider-01.jpg" alt="First slide">
         <img class="brand-two" src="<?php echo get_template_directory_uri(); ?>/img/brand-berklee.svg" width="180"/>
         <div class="carousel-caption d-md-block">
            <div class="row">
               <div class="col-sm-12 col-md-10 offset-md-1">
                  <p class="text-center mb-4"><img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/admision-2020.svg" width="500"/></p>
                  <h1 class="text-center text-uppercase main-title yellow">Intérprete en Jazz y Música Popular</h1>
                  <h5 class="text-center mt-4 mb-4">Especialízate con mención en canto o instrumento</h5>
                  <p> <a href="/web/admision-2021" class="btn btn-light btn-lg shadow">Inscríbete</a></p>
               </div>
            </div>
         </div>
      </div>
      <! ---------SLIDER 02--------->
      <div class="carousel-item">
         <img class="d-block" src="<?php echo get_template_directory_uri(); ?>/img/slider/slider-02.jpg" alt="First slide">
         <img class="brand-two" src="<?php echo get_template_directory_uri(); ?>/img/brand-berklee.svg" width="180"/>
         <div class="carousel-caption d-md-block">
            <div class="row">
               <div class="col-md-10 offset-md-1">
                  <p class="text-center mb-4"><img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/admision-2020.svg" width="500"/></p>
                  <h1 class="text-center text-uppercase main-title green">Producción Musical</h1>
                  <h5 class="text-center mt-4 mb-4">Da el siguiente paso e inicia tu carrera como productor</h5>
                  <p> <a href="/web/admision-2021" class="btn btn-light btn-lg shadow">Inscríbete</a></p>
               </div>
            </div>
         </div>
      </div>
      <! ---------SLIDER 03--------->
      <div class="carousel-item">
         <img class="d-block" src="<?php echo get_template_directory_uri(); ?>/img/slider/slider-03.jpg" alt="First slide">
         <img class="brand-two" src="<?php echo get_template_directory_uri(); ?>/img/brand-berklee.svg" width="180"/>
         <div class="carousel-caption d-md-block">
            <div class="row">
               <div class="col-md-10 offset-md-1">
                  <p class="text-center mb-4"><img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/admision-2020.svg" width="500"/></p>
                  <h1 class="text-center text-uppercase main-title yellow">Intérprete en Jazz y Música Popular</h1>
                  <h5 class="text-center mt-4 mb-4">Especialízate con mención en canto o instrumento</h5>
                  <p> <a href="/web/admision" class="btn btn-light btn-lg shadow">Inscríbete</a></p>
               </div>
            </div>
         </div>
      </div>
      <! ---------SLIDER 04--------->
      <div class="carousel-item">
         <img class="d-block" src="<?php echo get_template_directory_uri(); ?>/img/slider/slider-02.jpg" alt="First slide">
         <img class="brand-two" src="<?php echo get_template_directory_uri(); ?>/img/brand-berklee.svg" width="180"/>
         <div class="carousel-caption d-md-block">
            <div class="row">
               <div class="col-md-10 offset-md-1">
                  <p class="text-center mb-4"><img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/admision-2020.svg" width="500"/></p>
                  <h1 class="text-center text-uppercase main-title green">Composición Musical</h1>
                  <h5 class="text-center mt-4 mb-4">Mención Interpretación en Instrumento o canto</h5>
                  <p> <a href="/web/admision" class="btn btn-light btn-lg shadow">Inscríbete</a></p>
               </div>
            </div>
         </div>
      </div>
      <! ---------SLIDER 05 VIDEO--------->
      <div class="carousel-item active">
          <video autoplay muted loop id="myVideo" width="100%">
            <source src="<?php echo get_template_directory_uri(); ?>/video/projazz-inauguracion.mp4" type="video/mp4">
            Your browser does not support HTML5 video.
         </video>
         <div class="buttons">
            <button class="second" onclick="pauseVid()" type="button">
            <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/pause.svg" width="80"/></button>
            <button class="first" onclick="playVid()" type="button">
            <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/play.svg" width="80"/></button>
         </div>
      </div>
   </div>
   <a class="carousel-control-prev" href="#carousel" role="button" data-slide="prev">
   <span class="carousel-control-prev-icon" aria-hidden="true"></span>
   <span class="sr-only">Previous</span>
   </a>
   <a class="carousel-control-next" href="#carousel" role="button" data-slide="next">
   <span class="carousel-control-next-icon" aria-hidden="true"></span>
   <span class="sr-only">Next</span>
   </a>
</div>
<div class="container-fluid section">
   <div class="row">
      <div class="col-md-12 col-lg-4 offset-lg-1">
         <h2 class="text-uppercase mt-2">Casi <strong>40 Años</strong><br>fomentando el Talento Musical</h2>
         <p class="mt-4">Desde nuestra formación, <strong>Projazz</strong> se ha convertido en un referente y constante aporte al medio artístico nacional. 
            En 2007 el Ministerio de Educación nos reconoció como Instituto Profesional.
         </p>
         <p>Entérate un poco más de nuestra historia.</p>
         <p class="mt-4">
            <a href="/web/sobre-projazz" class="btn btn-primary btn-lg shadow mb-sm-5 mb-xs-5">Conócenos <img class="icon-button" width="22" src="<?php echo get_template_directory_uri(); ?>/img/i-chevron-right.svg"></span></a>
         </p>
      </div>
      <div class="col-md-12 col-lg-6">
         <div class="embed-responsive embed-responsive-16by9 shadow">
	         
	         
            <iframe class="embed-responsive-item" width="560" height="315" src="https://www.youtube.com/embed/nDGLR7_yp50?rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
         </div>
      </div>
   </div>
</div>
<div class="container-fluid section section-color-skew">
   <div class="row">
      <div class="col-md-12 offset-md-0 col-lg-6 offset-lg-1">
         <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/Photo-02.png"/>
      </div>
      <div class="col-lg-4">
         <h2 class="text-uppercase mt-2">¡En 2021 únete a Projazz y <strong>transforma tu potencial</strong> en una realidad!</h2>
         <p class="mt-4">Conoce nuestras carreras y descubre cuál de ellas es la indicada para ti, toma la decisión e inscríbete ahora mismo.</p>
         <p class="mt-4">
            <a href="/web/admision-2021" class="btn btn-light btn-lg shadow">Inscríbete <img class="icon-button" width="22" src="<?php echo get_template_directory_uri(); ?>/img/i-chevron-right-black.svg"></a>
         </p>
      </div>
   </div>
</div>
<div class="container-fluid section pb-0">
   <div class="row mb-4">
      <div class="col-12">
         <h5 class="text-uppercase text-center mb-2">Conoce nuestras</h5>
         <h2 class="text-uppercase text-center"><img class="chevron" width="40" src="<?php echo get_template_directory_uri(); ?>/img/chevron-left.svg"/><strong>Carreras</strong> Profesionales<img class="chevron" width="40" src="<?php echo get_template_directory_uri(); ?>/img/chevron-right.svg"/></h2>
      </div>
   </div>
   <div class="row">
      <div class="col-12 p-0">
         <div class="content-wall content-two-col">
            <a href="/web/interprete-en-jazz-y-musica-popular-canto/" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/carreras-1.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Intérprete en Jazz y Música popular</h3>
                        <p>Especialízate con mención en canto o instrumento</p>
                     </div>
                  </div>
               </div>
            </a>
            <a href="/web/composicion-musical-instrumento-o-canto/" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/carreras-2.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Composición Musical</h3>
                        <p>Con mención en canto o instrumento o música para cine y medios audiovisuales.</p>
                     </div>
                  </div>
               </div>
            </a>
            <a href="/web/produccion-musical/" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/carreras-3.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Producción Musical</h3>
                        <p>Da el siguiente paso e inicia tu carrera como productor</p>
                     </div>
                  </div>
               </div>
            </a>
            <a href="/web/pet/" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/carreras-4.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">PROGRAMA ESPECIAL DE TITULACIÓN PARA MÚSICOS</h3>
                        <p>Certifica tu conocimiento </p>
                     </div>
                  </div>
               </div>
            </a>
         </div>
      </div>
   </div>
</div>


<div class="container-fluid section pb-0 pt-0 mt-5">
   <div class="row mb-4">
      <div class="col-12">
         <h5 class="text-uppercase text-center mb-2">Complementa tus Conocimientos</h5>
         <h2 class="text-uppercase text-center"><img class="chevron" width="40" src="<?php echo get_template_directory_uri(); ?>/img/chevron-left.svg"/>Programa de <strong>educación continua</strong><img class="chevron" width="40" src="<?php echo get_template_directory_uri(); ?>/img/chevron-right.svg"/></h2>
      </div>
   </div>
   <div class="row">
      <div class="col-12">
         <div class="content-wall content-two-col">
            <a href="/web/minors-en-jazz" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/minors-portada.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Minors en Jazz</h3>
                        <p>Profundiza tus conocimientos</p>
                     </div>
                  </div>
               </div>
            </a>
            <!-- aca esta la seccion anterior
            <a href="/web/cursos" class="info shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/cursos.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Cursos y Talleres</h3>
                        <p>Aprende y crece profesionalmente</p>
                     </div>
                  </div>
               </div>
            </a> -->
            <a href="/web/preuniversitario" class="info two-col shadow" rel="bookmark">
               <div class="wall-post">
                  <img src="<?php echo get_template_directory_uri(); ?>/img/preuniversitario.jpg" class="img-responsive wp-post-image" alt="">         
                  <div class="mask">
                     <div class="mask-info">
                        <h3 class="text-uppercase">Preuniversitario Musical</h3>
                        <p>Prepárate para tu futuro</p>
                     </div>
                  </div>
               </div>
            </a>
         </div>
      </div>
   </div>
</div>

<?php include("partners.php"); ?>  
<div class="container-fluid section section-color cover-jazz">
   <div class="row">
      <div class="col-sm-12 col-md-12 col-lg-5 offset-lg-1 mt-5 mb-5">
         <h2 class="text-uppercase">¿Por qué <strong>estudiar</strong> en Projazz?</h2>
         <p class="mt-4">En 2021 estudia con nosotros: aprovecha la gran calidad docente, las carreras creadas de manera práctica para sacarle el jugo a tu estudios y la infraestructura perfecta para el quehacer musical.</p>
         <p class="mt-4">
            <a href="/web/docentes-area-instrumental/" class="btn btn-light btn-lg shadow">Docentes <img class="icon-button" width="22" src="<?php echo get_template_directory_uri(); ?>/img/i-chevron-right-black.svg"></a>
            <a href="/web/sobre-projazz/" class="btn btn-primary btn-lg shadow ml-2">Sobre projazz <img class="icon-button" width="22" src="<?php echo get_template_directory_uri(); ?>/img/i-chevron-right.svg"></a>
         </p>
      </div>
   </div>
</div>
<div class="container-fluid title-section pt-0">
   <div class="row">
      <div class="col-md-8 offset-md-1">
         <h2 class="text-uppercase">Cuerpo <strong>Docente</strong></h2>
      </div>
      <div class="col-md-2">
         <a href="/web/docentes-interprete-en-jazz-musica-popular/" class="text-right more">
            <h5 class="text-uppercase"><span>Todos</span> <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/i-arrow-right.svg"/></h5>
         </a>
      </div>
   </div>
</div>
<div class="container-fluid mb-5">
   <div class="row">
      <div class="col-md-12">
         <?php query_posts('category_name=docentes&showposts=4'); ?>
         <?php if (have_posts()) : ?>
         <?php while (have_posts()) : the_post(); ?>
         <a href="<?php the_permalink() ?>" class="info poster shadow" rel="bookmark">
            <div class="wall-post">
               <?php the_post_thumbnail('poster', array('class' => 'img-responsive')); ?>
               <div class="mask">
                  <div class="mask-info">
                     <h3><?php the_title(); ?></h3>
                     <p><?php echo excerpt(25); ?></p>
                  </div>
               </div>
            </div>
         </a>
         <?php endwhile; ?>
         <?php else :?>
         <?php endif; ?>
      </div>
   </div>
</div>
<div class="container-fluid title-section">
   <div class="row">
      <div class="col-md-8 offset-md-1">
         <h2 class="text-uppercase"><strong>Noticias</strong></h2>
      </div>
      <div class="col-md-2">
         <a href="/web/blog" class="text-right more">
            <h5 class="text-uppercase"><span>ir al blog</span> <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/i-arrow-right.svg"/></h5>
         </a>
      </div>
   </div>
</div>
<div class="content-wall">
   <?php query_posts('category_name=noticias&showposts=3'); ?>
   <?php if (have_posts()) : ?>
   <?php while (have_posts()) : the_post(); ?>
   <a href="<?php the_permalink() ?>" class="info shadow" rel="bookmark">
      <div class="wall-post">
         <?php the_post_thumbnail('medium', array('class' => 'img-responsive')); ?>
         <div class="mask">
            <div class="mask-info">
               <span class="category-label"><?php single_cat_title(); ?></span>
               <span class="date"><?php the_date(); ?></span>
               <h3><?php the_title(); ?></h3>
               <p><?php echo excerpt(25); ?></p>
            </div>
         </div>
      </div>
   </a>
   <?php endwhile; ?>
   <?php else :?>
   <?php endif; ?>
</div>
<div class="container-fluid title-section">
   <div class="row">
      <div class="col-md-8 offset-md-1">
         <h2 class="text-uppercase"><strong>Bandas</strong> Projazz</h2>
      </div>
      <div class="col-md-2">
         <a href="https://open.spotify.com/user/mrhqx87aaxyb31p6ns719s10t" target="_blank" class="text-right more">
            <h5 class="text-uppercase"><span>Escuchar</span> <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/i-arrow-right.svg"/></h5>
         </a>
      </div>
   </div>
</div>
<div class="container-fluid mb-5">
   <div class="row">
      <div class="col-md-12">
         <style>.embed-container { position: relative; padding-bottom: 25%; height: 0; overflow: hidden; max-width: 100%; } .embed-container iframe, .embed-container object, .embed-container embed { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }</style>
         <div class='embed-container'><iframe src='https://open.spotify.com/embed/playlist/4lX859Mi5nGQrs6is0i4Oo' width='300' height='380' frameborder='0' allowtransparency='true' allow='encrypted-media'></iframe></div>
      </div>
   </div>
</div>
<div class="container-fluid section section-color">
   <div class="title-section pt-0">
      <div class="row">
         <div class="col-md-8 offset-md-1">
            <h2 class="text-uppercase"><strong>Síguenos</strong><br>en instagram</h2>
         </div>
         <div class="col-md-2">
            <a href="https://www.instagram.com/projazzchile/" target="_blank" class="text-right more">
               <h5 class="text-uppercase"><span>Instagram</span> <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/i-arrow-right-white.svg"/></h5>
            </a>
         </div>
      </div>
   </div>
   <div class="row instagram-container">
      <?php dynamic_sidebar('widget-area-1'); ?>
   </div>
</div>
<?php get_footer(); ?>