<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function($) {
    function adjustSectionSize() {
        var winWidth = $(window).width(); // Detecta el ancho de la ventana

        if (winWidth <= 768) {
            // Aplicar ajustes para móviles
            $('.elementor-section').each(function() {
                $(this).css({
                    'max-width': '100%',
                    'padding': '10px',
                    'display': 'block', // Asegurarse de que la sección esté visible
                    'margin': '0 auto', // Centrar el contenedor
                    'visibility': 'visible', // Garantiza que sea visible
                });
            });
        } else {
            // Aplicar ajustes para escritorio
            $('.elementor-section').each(function() {
                $(this).css({
                    'max-width': '1200px',
                    'padding': '50px',
                    'display': 'block', // Asegurarse de que la sección esté visible
                    'margin': '0 auto', // Centrar el contenedor
                    'visibility': 'visible', // Garantiza que sea visible
                });
            });
        }
    }

    // Ejecutar el ajuste al cargar la página
    adjustSectionSize();

    // Ejecutar el ajuste cuando se cambia el tamaño de la ventana
    $(window).resize(function() {
        adjustSectionSize();
    });

    // Detectar cambios en Elementor (cuando cambias la vista dentro del editor)
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/global', function() {
            adjustSectionSize();
        });
    });
});</script>
<!-- end Simple Custom CSS and JS -->
